% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-wurcs.R
\name{parse_wurcs}
\alias{parse_wurcs}
\title{Parse WURCS Structures}
\usage{
parse_wurcs(x)
}
\arguments{
\item{x}{A character vector of WURCS strings. NA values are allowed and will be returned as NA structures.}
}
\value{
A \code{\link[glyrepr:glycan_structure]{glyrepr::glycan_structure()}} object.
}
\description{
This function parses WURCS strings into a \code{\link[glyrepr:glycan_structure]{glyrepr::glycan_structure()}}.
Currently, only WURCS 2.0 is supported.
For more information about WURCS, see \href{https://github.com/glycoinfo/WURCS/wiki}{WURCS}.
}
\examples{
wurcs <- paste0(
  "WURCS=2.0/3,5,4/",
  "[a2122h-1b_1-5_2*NCC/3=O][a1122h-1b_1-5][a1122h-1a_1-5]/",
  "1-1-2-3-3/a4-b1_b4-c1_c3-d1_c6-e1"
)
parse_wurcs(wurcs)

}
