% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco-get-countries.R
\encoding{UTF-8}
\name{gisco_get_countries}
\alias{gisco_get_countries}
\alias{gisco_get}
\title{Countries dataset}
\source{
\url{https://gisco-services.ec.europa.eu/distribution/v2/}.

Copyright:
\url{https://ec.europa.eu/eurostat/web/gisco/geodata/administrative-units}.
}
\usage{
gisco_get_countries(
  year = 2024,
  epsg = 4326,
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  resolution = 20,
  spatialtype = "RG",
  country = NULL,
  region = NULL,
  ext = "gpkg"
)
}
\arguments{
\item{year}{character string or number. Release year of the file. One of
\Sexpr[stage=render,results=rd]{giscoR:::db_values("countries",
"year",TRUE)}.}

\item{epsg}{character string or number. Projection of the map: 4-digit
\href{https://epsg.io/}{EPSG code}. One of:
\itemize{
\item \code{"4326"}: \href{https://epsg.io/4326}{WGS84}.
\item \code{"3035"}: \href{https://epsg.io/3035}{ETRS89 / ETRS-LAEA}.
\item \code{"3857"}: \href{https://epsg.io/3857}{Pseudo-Mercator}.
}}

\item{cache}{logical. Whether to do caching. Default is \code{TRUE}. See
\strong{Caching strategies} section in \code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}}.}

\item{update_cache}{logical. Should the cached file be refreshed?. Default
is \code{FALSE}. When set to \code{TRUE} it would force a new download.}

\item{cache_dir}{character string. A path to a cache directory. See
\strong{Caching strategies} section in \code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}}.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}

\item{resolution}{character string or number. Resolution of the geospatial
data. One of:
\itemize{
\item \code{"60"}: 1:60 million.
\item \code{"20"}: 1:20 million.
\item \code{"10"}: 1:10 million.
\item \code{"03"}: 1:3 million.
\item \code{"01"}: 1:1 million.
}}

\item{spatialtype}{character string. Type of geometry to be returned.
Options available are:
\itemize{
\item \code{"RG"}: Regions - \code{MULTIPOLYGON/POLYGON} object.
\item \code{"LB"}: Labels - \code{POINT} object.
\item \code{"BN"}: Boundaries - \code{LINESTRING} object.
\item \code{"COASTL"}: coastlines - \code{LINESTRING} object.
\item \code{"INLAND"}: inland boundaries - \code{LINESTRING} object.
}

\strong{Note that} arguments \code{country} and \code{region} would be
only applied when \code{spatialtype} is \code{"RG"} or \code{"LB"}.}

\item{country}{character vector of country codes. It could be either a
vector of country names, a vector of ISO3 country codes or a vector of
Eurostat country codes. See also \code{\link[countrycode:countrycode]{countrycode::countrycode()}}.}

\item{region}{Optional. A character vector of UN M49 region codes or
European Union membership. Possible values are \code{"Africa"}, \code{"Americas"},
\code{"Asia"}, \code{"Europe"}, \code{"Oceania"} or \code{"EU"} for countries belonging to the
European Union (as per 2021). See \strong{World Regions} and
\link{gisco_countrycode}.}

\item{ext}{character. Extension of the file (default \code{"gpkg"}). One of
\Sexpr[stage=render,results=rd]{giscoR:::db_values("countries",
"ext",TRUE)}.}
}
\value{
A \code{\link[sf:sf]{sf}} object.
}
\description{
This dataset contains the administrative boundaries at country level of the
world. This dataset consists of 2 feature classes (regions, boundaries) per
scale level and there are 5 different scale levels (1M, 3M, 10M, 20M and
60M).

\strong{Please note that} this function gets data from the aggregated GISCO
country file. If you prefer to download individual country files, please use
\code{\link[=gisco_get_unit_country]{gisco_get_unit_country()}}.
}
\section{World Regions}{
Regions are defined as per the geographic regions defined by the
UN (see \url{https://unstats.un.org/unsd/methodology/m49/}.
Under this scheme Cyprus is assigned to Asia.
}

\section{Note}{
Please check the download and usage provisions on \code{\link[=gisco_attributions]{gisco_attributions()}}.
}

\examples{
cntries <- gisco_get_countries()

library(ggplot2)
ggplot(cntries) +
  geom_sf()

# Get a region

africa <- gisco_get_countries(region = "Africa")
ggplot(africa) +
  geom_sf(fill = "#078930", col = "white") +
  theme_minimal()
}
\seealso{
\link{gisco_countrycode}, \link{gisco_countries_2024}, \code{\link[=gisco_get_metadata]{gisco_get_metadata()}},
\code{\link[countrycode:countrycode]{countrycode::countrycode()}}.

See \code{\link[=gisco_bulk_download]{gisco_bulk_download()}} to perform a bulk download of datasets.

See \code{\link[=gisco_get_unit_country]{gisco_get_unit_country()}} to download single files.

See \code{\link[=gisco_id_api_country]{gisco_id_api_country()}} to download via GISCO ID service API.

Other administrative units datasets:
\code{\link{gisco_get_communes}()},
\code{\link{gisco_get_postal_codes}()}
}
\concept{admin}
