% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggseg3d.R
\name{ggseg3d}
\alias{ggseg3d}
\title{Plot 3D brain parcellations}
\usage{
ggseg3d(
  .data = NULL,
  atlas = dk(),
  label_by = "region",
  text_by = NULL,
  colour_by = "colour",
  palette = NULL,
  na_colour = "darkgrey",
  na_alpha = 1,
  ...,
  label = deprecated(),
  text = deprecated(),
  colour = deprecated()
)
}
\arguments{
\item{.data}{A data.frame to use for plot aesthetics. Must include a
column called "region" corresponding to regions.}

\item{atlas}{A `ggseg_atlas` object containing 3D vertex mappings, or a
string naming an atlas function (deprecated).}

\item{label_by}{String. Column name used as hover label for each region.}

\item{text_by}{String. Column name for extra hover text shown below the
region label.}

\item{colour_by}{String. Column name mapped to mesh colours.}

\item{palette}{String. Vector of colour names or HEX colours. Can also
be a named numeric vector, with colours as names, and breakpoint for
that colour as the value}

\item{na_colour}{String. Either name, hex of RGB for colour of NA in
colour.}

\item{na_alpha}{Numeric. A number between 0 and 1 to control
transparency of NA-regions.}

\item{...}{Type-specific arguments passed to the atlas method.
See section **Type-specific arguments** below.}

\item{label, text, colour}{`r lifecycle::badge("deprecated")` Use
`label_by`, `text_by`, and `colour_by` instead.}
}
\value{
an htmlwidget object for interactive 3D brain visualization
}
\description{
`ggseg3d` creates and returns an interactive Three.js brain mesh
visualization. Dispatches to atlas-type-specific methods via
[prepare_brain_meshes()].
}
\section{Type-specific arguments}{

Cortical atlases (`cortical_atlas`):
\describe{
  \item{`surface`}{Surface type: `"LCBC"` (default, alias for
    inflated), `"inflated"`, `"semi-inflated"`, `"white"`, `"pial"`.}
  \item{`hemisphere`}{Character vector of hemispheres: `"right"`,
    `"left"`.}
  \item{`edge_by`}{Column name for region boundary edges.}
  \item{`brain_meshes`}{Custom brain mesh data.}
}

Tract atlases (`tract_atlas`):
\describe{
  \item{`tract_color`}{`"palette"` (default) or `"orientation"`
    (direction-based RGB).}
  \item{`tube_radius`}{Tube radius (numeric, default 5).}
  \item{`tube_segments`}{Tube segment count (integer, default 8).}
}
}

\examples{
\dontrun{
ggseg3d()
ggseg3d(hemisphere = "left") |> pan_camera("left lateral")
ggseg3d() |> set_legend(FALSE)
ggseg3d() |> set_background("black")
}

}
\seealso{
[pan_camera()] for camera position, [set_background()] for
  background colour, [set_legend()] for legend visibility
}
\author{
Athanasia Mowinckel and Didac Piñeiro
}
