% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggseg_atlas_data.R
\name{ggseg_data_cortical}
\alias{ggseg_data_cortical}
\alias{brain_data_cortical}
\title{Create cortical atlas data}
\usage{
ggseg_data_cortical(sf = NULL, vertices = NULL)

brain_data_cortical(sf = NULL, vertices = NULL)
}
\arguments{
\item{sf}{sf data.frame with columns label, view, geometry for 2D rendering.
Optional but required for ggseg plotting.}

\item{vertices}{data.frame with columns label and vertices (list-column of
integer vectors). Each vector contains vertex indices for that region.}
}
\value{
An object of class c("ggseg_data_cortical", "ggseg_atlas_data")
}
\description{
Creates a data object for cortical brain atlases. Cortical atlases use
vertex indices that map regions to vertices on a shared brain surface mesh
(e.g., fsaverage5).
}
\examples{
data <- ggseg_data_cortical(
  vertices = data.frame(
    label = c("bankssts", "caudalanteriorcingulate"),
    vertices = I(list(c(1L, 2L, 3L), c(4L, 5L, 6L)))
  )
)
}
