% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_type_sizef}
\alias{ggml_type_sizef}
\title{Get Type Size as Float}
\usage{
ggml_type_sizef(type)
}
\arguments{
\item{type}{GGML type constant}
}
\value{
Numeric size in bytes (can be fractional for quantized types)
}
\description{
Returns the size in bytes of a GGML type as a floating-point number.
For quantized types, this is the average bytes per element.
}
\examples{
ggml_type_sizef(GGML_TYPE_F32)  # 4.0
ggml_type_sizef(GGML_TYPE_F16)  # 2.0
}
\seealso{
Other type_system: 
\code{\link{ggml_blck_size}()},
\code{\link{ggml_ftype_to_ggml_type}()},
\code{\link{ggml_is_quantized}()},
\code{\link{ggml_type_name}()}
}
\concept{type_system}
