% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_mean}
\alias{ggml_mean}
\title{Mean (Graph)}
\usage{
ggml_mean(ctx, a)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor}
}
\value{
Scalar tensor with the mean
}
\description{
Creates a graph node that computes the mean of all elements.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
ggml_set_f32(a, c(2, 4, 6, 8, 10))
result <- ggml_mean(ctx, a)
graph <- ggml_build_forward_expand(ctx, result)
ggml_graph_compute(ctx, graph)
output <- ggml_get_f32(result)  # 6
ggml_free(ctx)
}
}
