% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_layers.R
\name{ggml_layer_max_pooling_2d}
\alias{ggml_layer_max_pooling_2d}
\title{Add 2D Max Pooling Layer}
\usage{
ggml_layer_max_pooling_2d(
  model,
  pool_size = c(2L, 2L),
  strides = NULL,
  name = NULL,
  trainable = TRUE
)
}
\arguments{
\item{model}{A ggml_sequential_model object}

\item{pool_size}{Integer or vector of 2 integers for pool height and width}

\item{strides}{Integer or vector of 2 integers (defaults to pool_size)}

\item{name}{Optional character name for the layer.}

\item{trainable}{Logical; reserved for API consistency (no weights).}
}
\value{
The model object with the max pooling layer appended (invisibly).
}
\description{
Add 2D Max Pooling Layer
}
\examples{
\donttest{
model <- ggml_model_sequential() |>
  ggml_layer_conv_2d(32, c(3,3), activation = "relu",
                     input_shape = c(28, 28, 1)) |>
  ggml_layer_max_pooling_2d(c(2, 2))
}
}
