% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_group_norm_inplace}
\alias{ggml_group_norm_inplace}
\title{Group Normalization In-place (Graph)}
\usage{
ggml_group_norm_inplace(ctx, a, n_groups, eps = 1e-05)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor (will be modified in-place)}

\item{n_groups}{Number of groups}

\item{eps}{Epsilon for numerical stability (default 1e-5)}
}
\value{
View of input tensor with group norm applied
}
\description{
Creates a graph node for in-place group normalization.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_2d(ctx, GGML_TYPE_F32, 4, 8)
ggml_set_f32(a, rnorm(32))
result <- ggml_group_norm_inplace(ctx, a, n_groups = 2)
graph <- ggml_build_forward_expand(ctx, result)
ggml_graph_compute(ctx, graph)
ggml_free(ctx)
}
}
