% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_gelu_quick}
\alias{ggml_gelu_quick}
\title{GELU Quick Activation (Graph)}
\usage{
ggml_gelu_quick(ctx, a)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor}
}
\value{
Tensor representing the GELU quick operation
}
\description{
Creates a graph node for fast approximation of GELU.
Faster than standard GELU with minimal accuracy loss.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
ggml_set_f32(a, c(-2, -1, 0, 1, 2))
result <- ggml_gelu_quick(ctx, a)
graph <- ggml_build_forward_expand(ctx, result)
ggml_graph_compute(ctx, graph)
output <- ggml_get_f32(result)
ggml_free(ctx)
}
}
