% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autograd.R
\name{ag_linear}
\alias{ag_linear}
\title{Create a dense layer with learnable parameters}
\usage{
ag_linear(in_features, out_features, activation = NULL)
}
\arguments{
\item{in_features}{Input dimension}

\item{out_features}{Output dimension}

\item{activation}{"relu", "sigmoid", "tanh", "softmax", or NULL}
}
\value{
List with \code{W}, \code{b}, \code{forward(x)}, \code{params()}
}
\description{
Returns a closure-based layer.  Because ag_param uses environment semantics,
the optimizer updates W and b in-place, and forward() always uses the latest
weights.
}
\examples{
\donttest{
layer <- ag_linear(4L, 8L, activation = "relu")
x     <- ag_tensor(matrix(runif(4 * 16), 4, 16))
out   <- layer$forward(x)
}
}
