% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labs2.R
\name{easy_labs}
\alias{easy_labs}
\title{Easily add ggplot labels using label attribute of `data.frame` column}
\usage{
easy_labs(..., teach = FALSE)
}
\arguments{
\item{...}{A list of new name-value pairs. The name should either be an aesthetic,
or one of "title", "subtitle", or "caption"}

\item{teach}{print longer equivalent \code{\link[ggplot2]{ggplot2}}
expression?}
}
\description{
Applies same logic as \code{\link[ggplot2]{labs}} but uses as default
the column label attribute if present as the variable label in the plot.
Note that as of ggplot2 3.5.2.9001 this behaviour is native and this function will
be deprecated.
}
\examples{
\dontrun{
iris_labs <- iris

lbl <- c('Sepal Length', 'Sepal Width', 'Petal Length', 'Petal Width', 'Flower Species')

labelled::var_label(iris_labs) <- split(lbl,names(iris_labs))

p <- ggplot2::ggplot(iris_labs,ggplot2::aes(x=Sepal.Length,y=Sepal.Width))+
  ggplot2::geom_line(ggplot2::aes(colour=Species))

p

p + easy_labs()
p + easy_labs(title = "Plot Title", subtitle = 'Plot Subtitle', x = 'x axis label')

p + easy_labs(teach = TRUE)
}
}
