% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot-helper.R
\name{theme_no_axes}
\alias{theme_no_axes}
\title{Remove axis elements}
\usage{
theme_no_axes(
  axes = "xy",
  text = TRUE,
  ticks = TRUE,
  title = TRUE,
  line = FALSE
)
}
\arguments{
\item{axes}{Which axes elements should be removed? A string containing
one or more of \code{"t"}, \code{"l"}, \code{"b"}, \code{"r"}, \code{"x"}, and \code{"y"}.}

\item{text}{If \code{TRUE}, will remove the axis labels.}

\item{ticks}{If \code{TRUE}, will remove the axis ticks.}

\item{title}{If \code{TRUE}, will remove the axis title.}

\item{line}{If \code{TRUE}, will remove the axis line.}
}
\value{
A \code{\link[ggplot2:theme]{theme()}} object.
}
\description{
Remove axis elements
}
\examples{
p <- ggplot() +
    geom_point(aes(x = wt, y = qsec), data = mtcars)
p + theme_no_axes()
p + theme_no_axes("b")
p + theme_no_axes("l")
}
