% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worktree.R
\name{git_worktree}
\alias{git_worktree}
\alias{git_worktree_list}
\alias{git_worktree_exists}
\alias{git_worktree_path}
\alias{git_worktree_add}
\alias{git_worktree_remove}
\alias{git_worktree_prune}
\alias{git_worktree_is_prunable}
\alias{git_worktree_lock}
\alias{git_worktree_unlock}
\alias{git_worktree_is_locked}
\alias{git_worktree_is_valid}
\title{Git Worktrees}
\usage{
git_worktree_list(repo = ".")

git_worktree_exists(name, repo = ".")

git_worktree_path(name, repo = ".")

git_worktree_add(name, path, branch, lock = FALSE, local = TRUE, repo = ".")

git_worktree_remove(name, repo = ".")

git_worktree_prune(
  name,
  prune_valid = FALSE,
  prune_locked = FALSE,
  prune_working_tree = FALSE,
  repo = "."
)

git_worktree_is_prunable(
  name,
  prune_valid = FALSE,
  prune_locked = FALSE,
  repo = "."
)

git_worktree_lock(name, repo = ".")

git_worktree_unlock(name, repo = ".")

git_worktree_is_locked(name, repo = ".")

git_worktree_is_valid(name, repo = ".")
}
\arguments{
\item{repo}{The path to the git repository. If the directory is not a
repository, parent directories are considered (see \link{git_find}). To disable
this search, provide the filepath protected with \code{\link[=I]{I()}}. When using this
parameter, always explicitly call by name (i.e. \verb{repo = }) because future
versions of gert may have additional parameters.}

\item{name}{The name of the worktree.}

\item{path}{The path to checkout \code{branch} into. Importantly, the path up to
the folder name must exist, but the folder name itself must not exist yet
and will be created.}

\item{branch}{The branch to checkout into \code{path}.}

\item{lock}{Whether or not to lock the worktree on creation.}

\item{local}{set TRUE to only check for local branches, FALSE to check for remote
branches. Use NULL to return all branches.}

\item{prune_valid}{Whether or not to forcibly prune a \emph{valid} worktree.}

\item{prune_locked}{Whether or not to forcibly prune a \emph{locked} worktree.}

\item{prune_working_tree}{Whether or not to also remove the folder that the
worktree was using, i.e. the \code{path} supplied to \code{git_worktree_add()}.}
}
\description{
Worktrees represent an alternative location to checkout a branch into. Rather
than checking out a branch in your main working tree (which changes the
branch you are currently on and forces you to stash any existing work), you
can instead check that branch out into a separate \emph{linked worktree} with its
own working tree. Practically, a worktree is just a separate folder that a
branch is checked out into, with some extra git metadata that links it back
to the main working tree.

\code{git_worktree_list()} returns a data frame of information about the worktrees
linked to the main working tree.

\code{git_worktree_exists()} lets you check whether or not a worktree by the name
of \code{name} exists for this \code{repo}.

\code{git_worktree_path()} returns the file path to the worktree.

\code{git_worktree_add()} creates a new worktree called \code{name} in the folder
pointed to by \code{path}, and checks \code{branch} out into it.

\code{git_worktree_remove()} removes a worktree. It does so by deleting the folder
provided as the \code{path} to \code{git_worktree_add()}, and then cleaning up some git
metadata in the main working tree that linked the main working tree to the
removed worktree. The \code{branch} checked out by the worktree is not deleted.
Note that this is just a wrapper around \code{git_worktree_prune()} that sets some
desirable defaults for aggressive removal.

\code{git_worktree_prune()} is more cautious than \code{git_worktree_remove()}. It
refuses to prune \emph{valid} or \emph{locked} worktrees by default, and also refuses
the delete the working tree of the worktree by default (i.e. the folder at
\code{path}). It is automatically run by git itself on periodic intervals to prune
outdated worktrees. For interactive usage, you typically want
\code{git_worktree_remove()} instead. \code{git_worktree_is_prunable()} lets you check
if a worktree is prunable with the given options.

\code{git_worktree_lock()}, \code{git_worktree_unlock()}, and
\code{git_worktree_is_locked()} help you manage whether or not a worktree is
\emph{locked}. When a worktree is locked, it is not automatically cleaned up by
\code{git_worktree_prune()} (and git itself) on periodic intervals, even when it
looks \emph{invalid}. This is typically only useful when your worktree is on a
hard drive that isn't always connected (which can make it look \emph{invalid} when
disconnected, typically making it a candidate for automatic pruning).

\code{git_worktree_is_valid()} checks whether a worktree is valid or not. A
\emph{valid} worktree requires both the git data structures inside the main
working tree and this worktree to be present.
}
\examples{
repo <- git_init(tempfile("gert-examples-repo"))

writeLines("hello", file.path(repo, 'hello.txt'))
git_add('hello.txt', repo = repo)
git_commit("First commit", author = "jeroen <jeroen@blabla.nl>", repo = repo)

# Create a branch that is going to be used for the worktree,
# but don't check it out!
git_branch_create(branch = "branch", checkout = FALSE, repo = repo)

path <- tempfile("gert-examples-worktree")

# Add a worktree for this branch
git_worktree_add(
  name = "worktree",
  path = path,
  branch = "branch",
  repo = repo
)

# Worktree info
git_worktree_list(repo = repo)

# Note how the files are checked out here
dir(path, all.files = TRUE)

# And the branch that we are on at `path` is `"branch"`
git_branch(repo = path)

# Cleanup worktree, and the folder at `path`
git_worktree_remove("worktree", repo = repo)

# Cleanup repo
unlink(repo, recursive = TRUE)
}
\seealso{
Other git: 
\code{\link{git_archive}},
\code{\link{git_branch}()},
\code{\link{git_commit}()},
\code{\link{git_config}()},
\code{\link{git_diff}()},
\code{\link{git_fetch}()},
\code{\link{git_ignore}},
\code{\link{git_merge}()},
\code{\link{git_rebase}()},
\code{\link{git_remote}},
\code{\link{git_repo}},
\code{\link{git_reset}()},
\code{\link{git_signature}()},
\code{\link{git_stash}},
\code{\link{git_tag}}
}
\concept{git}
