% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdal_helpers.R
\name{gdal_compute_version}
\alias{gdal_compute_version}
\title{Compute a GDAL integer version number from major, minor, revision}
\usage{
gdal_compute_version(maj, min, rev)
}
\arguments{
\item{maj}{Numeric value, major version component (coerced to integer by
truncation).}

\item{min}{Numeric value, min version component (coerced to integer by
truncation).}

\item{rev}{Numeric value, revision version component (coerced to integer by
truncation).}
}
\value{
Integer version number compatible with \code{gdal_version_num()}.
}
\description{
\code{gdal_compute_version()} computes a full integer version number
(GDAL_VERSION_NUM) from individual components (major, minor, revision).
Convenience function for checking a GDAL version requirement using
\code{gdal_version_num()}.
}
\examples{
(gdal_version_num() >= gdal_compute_version(3, 7, 0))
}
\seealso{
\code{\link[=gdal_version_num]{gdal_version_num()}}
}
