% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VolElliptope.R
\name{VolElliptope}
\alias{VolElliptope}
\title{Compute the volume of the elliptope of possible correlation 
matrices of a given dimension.}
\usage{
VolElliptope(NVar)
}
\arguments{
\item{NVar}{(integer) The size of each correlation matrix in the elliptope. 
For instance, if we are interested in the volume of the space of all possible 
5 x 5  correlation matrices then \code{NVar = 5}.}
}
\value{
\code{VolElliptope} returns the following objects:
\itemize{
   \item  \strong{VolElliptope} (numeric) The volume of the elliptope.
   \item  \strong{VolCube}: (numeric) The volume of the embedding 
   hyper-cube.
   \item \strong{PrcntCube} (numeric) The percent of the hyper-cube that is 
   occupied by the elliptope. \code{PrcntCube = 100 x VolElliptope/VolCube}.
}
}
\description{
Compute the volume of the elliptope of possible correlation 
matrices of a given dimension.
}
\examples{
# Compute the volume of a 5 x 5 correlation matrix.

VolElliptope(NVar = 5)

}
\references{
Joe, H. (2006). Generating random correlation matrices 
based on partial correlations. *Journal of Multivariate Analysis*, 
*97* (10), 2177--2189. 

Hürlimann, W. (2012). Positive semi-definite 
correlation matrices: Recursive algorithmic generation and volume 
measure. *Pure Mathematical Science, 1* (3), 137--149.
}
\author{
Niels G. Waller
}
