% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_mfd.R
\name{mean.mfd}
\alias{mean.mfd}
\title{Mean Function for Multivariate Functional Data}
\usage{
\method{mean}{mfd}(x, ...)
}
\arguments{
\item{x}{An object of class \code{mfd}, containing \eqn{N} observations of a
\eqn{p}-dimensional multivariate functional variable.}

\item{...}{Further arguments are ignored (required for S3 consistency).}
}
\value{
An object of class \code{mfd} representing the mean function. The
output contains a single observation, corresponding to the mean function
for each variable.
}
\description{
Computes the mean function for an object of class \code{mfd}.
}
\details{
The method averages the coefficient array across the observation dimension,
resulting in a new \code{mfd} object with one observation (the sample mean).
}
\examples{
\donttest{
library(funcharts)
data(air)
mfdobj <- get_mfd_list(air)
mean_result <- mean(mfdobj)
plot(mean_result)
}

}
\seealso{
\code{\link{mfd}}, \code{\link{plot.mfd}}
}
