% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probKMA_silhouette_filter.R
\name{probKMA_silhouette_filter}
\alias{probKMA_silhouette_filter}
\title{Filter Motifs from probKMA Results Based on Silhouette and Size Thresholds}
\usage{
probKMA_silhouette_filter(
  probKMA_results,
  silhouette,
  sil_threshold = 0.5,
  size_threshold = 2
)
}
\arguments{
\item{probKMA_results}{A list representing the output of the `probKMA` function with `return_options = TRUE`. This output includes the motifs, dissimilarity matrices, and membership matrices required for filtering.}

\item{silhouette}{A list output from the `probKMA_silhouette` function, which provides silhouette scores for each motif.}

\item{sil_threshold}{A numeric value representing the threshold for the average silhouette index. Motifs with a silhouette index greater than or equal to this value will be retained. Default is 0.5.}

\item{size_threshold}{An integer representing the minimum number of curves (size) in a motif cluster. Motifs with a cluster size greater than or equal to this value will be retained. Default is 2.}
}
\value{
A list containing the filtered results:
\item{V0_clean}{Filtered motifs.}
\item{V1_clean}{Derivatives of the filtered motifs.}
\item{D}{Dissimilarity matrix.}
\item{D_clean}{Filtered dissimilarity matrix after cleaning motifs.}
\item{P}{Membership matrix.}
\item{P_clean}{Filtered membership matrix after cleaning motifs.}
\item{c}{Filtered minimum motif lengths.}
\item{K}{Vector containing the number of motifs repeated by the filtered motifs.}
}
\description{
This function filters the motifs identified by the `probKMA` algorithm based on a threshold for the average silhouette index and a minimum size criterion. Motifs that meet or exceed both the silhouette index threshold and the minimum number of curves (size) are retained. The function returns a cleaned version of the input data, including the filtered motifs, their derivatives, and associated matrices.
}
