% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_quarto.R
\name{write_quarto}
\alias{write_quarto}
\title{Create a New Quarto Document}
\usage{
write_quarto(filename = "Untitled-1", path = here::here())
}
\arguments{
\item{filename}{Character. The name of the file without the \code{.qmd}
extension. Only letters, numbers, hyphens, and underscores are allowed.
Default is \code{"Untitled-1"}.}

\item{path}{Character. Path to the project directory. Default is current project
root via \code{\link[here]{here}}.}
}
\value{
Invisibly returns the path to the created Quarto document.
}
\description{
Downloads the Quarto template from the
\href{https://github.com/kyleGrealis/frogger-templates}{frogger-templates}
repository and writes it to the \code{pages/} directory. Errors if a file
with the same name already exists.
}
\details{
The file is written to \code{pages/<filename>.qmd}. The \code{pages/}
directory is created automatically if it does not exist.
}
\examples{
\dontrun{
# Create a Quarto document with the default name
write_quarto()

# Create a Quarto document with a custom name
write_quarto(filename = "analysis")
}

}
\seealso{
\code{\link{init}}, \code{\link{write_variables}},
  \code{\link{write_brand}}
}
