% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brand_settings.R
\name{brand_settings}
\alias{brand_settings}
\title{Manage Brand Settings for froggeR Quarto Projects}
\usage{
brand_settings()
}
\value{
Invisibly returns \code{NULL}. Called for side effects (interactive
  configuration).
}
\description{
Interactively configure your branding (colors, logos, organization name) for
reuse across multiple Quarto projects.
}
\details{
This function provides an interactive workflow with three main options:

\enumerate{
  \item \strong{Create or update branding}: Interactively configure:
    \itemize{
      \item Organization/project name
      \item Primary brand color (hex format, e.g., #0066cc)
      \item Large logo path
      \item Small/icon logo path
      \item Optional: Advanced customization through template editing
    }
  \item \strong{View current branding}: Display existing project-level and
    global brand configurations
  \item \strong{Exit}: Return to console
}

After configuring basic settings, you can choose to:
\itemize{
  \item Save with the basics (quick setup)
  \item Edit the full template for advanced options (typography, color palettes,
    links, code styling, headings)
}

Branding is stored as YAML (\code{_brand.yml}) in:
\itemize{
  \item Project-level: \code{_brand.yml} in the current Quarto project
  \item Global: System-wide config directory (reused across all projects)
  \item Both: Saved to both locations
}

Global branding is automatically applied in new projects via
\code{\link{quarto_project}} and \code{\link{write_brand}}.
}
\examples{
# Open interactive brand settings configuration
if (interactive()) {
  froggeR::brand_settings()
}

}
\seealso{
\code{\link{settings}}, \code{\link{write_brand}},
  \code{\link{save_brand}}
}
