% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_content.R
\name{use_flextable_qmd}
\alias{use_flextable_qmd}
\title{Install the flextable-qmd Quarto extension}
\usage{
use_flextable_qmd(path = ".", quiet = FALSE)
}
\arguments{
\item{path}{Path to the Quarto project root. Defaults
to the current working directory.}

\item{quiet}{If \code{TRUE}, suppress informational messages.}
}
\value{
The path to the installed extension (invisibly).
}
\description{
Copies the \code{flextable-qmd} Quarto extension (bundled with
flextable) into the \verb{_extensions/} directory of a
Quarto project. The extension provides Lua filters
that resolve Quarto markdown content produced by
\code{\link[=as_qmd]{as_qmd()}} inside flextable cells for HTML, PDF
and Word (docx) output formats.

After installation, add the filter to your document
or project YAML:

\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{filters:
  - flextable-qmd
}\if{html}{\out{</div>}}

For Word (docx) output with labelled flextable chunks
(e.g. \verb{#| label: tbl-xxx}), add the post-render filter
to remove the wrapper table Quarto creates around the
flextable:

\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{filters:
  - flextable-qmd
  - at: post-render
    path: _extensions/flextable-qmd/unwrap-float.lua
}\if{html}{\out{</div>}}
}
\examples{
\dontrun{
use_flextable_qmd()
}
}
\seealso{
\code{\link[=as_qmd]{as_qmd()}} for creating Quarto markdown chunks,
\code{\link[=knit_print.flextable]{knit_print.flextable()}} for rendering options in knitr documents.
}
