% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Uniform.R
\name{pUNI}
\alias{pUNI}
\title{Uniform Distribution Bounded Between [0,1]}
\usage{
pUNI(p)
}
\arguments{
\item{p}{vector of probabilities.}
}
\value{
The output of \code{pUNI} gives the cumulative density values in vector form.
}
\description{
These functions provide the ability for generating probability density values,
cumulative probability density values and moments about zero values for the
Uniform Distribution bounded between [0,1].
}
\details{
Setting \eqn{a=0} and \eqn{b=1} in the Uniform Distribution
a unit bounded Uniform Distribution can be obtained. The probability density function
and cumulative density function of a unit bounded Uniform Distribution with random
variable P are given by

\deqn{g_{P}(p) = 1}    \eqn{0 \le p \le 1}
\deqn{G_{P}(p) = p}    \eqn{0 \le p \le 1}

The mean and the variance are denoted as
\deqn{E[P]= \frac{1}{a+b}= 0.5}
\deqn{var[P]= \frac{(b-a)^2}{12}= 0.0833}

Moments about zero is denoted as
\deqn{E[P^r]= \frac{e^{rb}-e^{ra}}{r(b-a)}= \frac{e^r-1}{r} }
\eqn{r = 1,2,3,...}

\strong{NOTE} : If input parameters are not in given domain conditions necessary
error messages will be provided to go further.
}
\examples{
#plotting the random variables and probability values
plot(seq(0,1,by=0.01),dUNI(seq(0,1,by=0.01))$pdf,type = "l",main="Probability density graph",
xlab="Random variable",ylab="Probability density values")

dUNI(seq(0,1,by=0.05))$pdf     #extract the pdf values
dUNI(seq(0,1,by=0.01))$mean    #extract the mean
dUNI(seq(0,1,by=0.01))$var     #extract the variance

#plotting the random variables and cumulative probability values
plot(seq(0,1,by=0.01),pUNI(seq(0,1,by=0.01)),type = "l",main="Cumulative density graph",
xlab="Random variable",ylab="Cumulative density values")

pUNI(seq(0,1,by=0.05))     #acquiring the cumulative probability values

mazUNI(c(1,2,3))    #acquiring the moment about zero values

#only the integer value of moments is taken here because moments cannot be decimal
mazUNI(1.9)

}
\references{
\insertRef{horsnell1957economical}{fitODBOD}
\insertRef{johnson1995continuous}{fitODBOD}
}
\seealso{
\code{\link[stats]{Uniform}}

or

\url{https://stat.ethz.ch/R-manual/R-devel/library/stats/html/Uniform.html}
}
