% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_finna_collection.R
\name{fetch_finna}
\alias{fetch_finna}
\title{Fetch Finna Collection Data with Flexible Query}
\usage{
fetch_finna(
  query = NULL,
  limit = 0,
  facets = "building",
  lng = "fi",
  prettyPrint = TRUE
)
}
\arguments{
\item{query}{The query string for filtering results. Defaults to NULL, which fetches data without a specific search term.}

\item{limit}{Maximum number of results to fetch. Defaults to 0.}

\item{facets}{Facet to retrieve, defaults to "building".}

\item{lng}{Language for results, defaults to "fi".}

\item{prettyPrint}{Logical, whether to pretty-print JSON responses.}
}
\value{
A tibble containing the fetched data with relevant fields.
}
\description{
This function retrieves data from the Finna API and formats it as a tidy tibble.
}
\examples{
\dontrun{
  fetch_finna(query = "record_format:ead", limit = 0)
  fetch_finna() # Fetches data with no specific query
}
}
