% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{P_data_info}
\alias{P_data_info}
\title{Metadata for Parkinson Subjects}
\format{
A data frame with the following variables:
\describe{
  \item{ID}{Subject identifier (e.g., SUB01).}
  \item{Gender}{Sex of the subject (e.g., M/F).}
  \item{Age}{Age in years.}
  \item{Height..cm.}{Height in centimeters.}
  \item{Weight..kg.}{Body weight in kilograms.}
  \item{BMI..kg.m2.}{Body mass index in kg/m\eqn{^2}.}
  \item{Ortho.Prosthesis}{Use of orthotic and/or prosthetic device.}
  \item{Years.of.formal.study}{Years of formal education completed.}
  \item{Disease.duration..years.}{Time since Parkinson’s disease diagnosis (years).}
  \item{L.Dopa.equivalent.units..mg.day.1.}{Levodopa equivalent daily dose (mg/day).}
  \item{FoG.group}{Classification based on freezing of gait (e.g., freezer/non-freezer).}
  \item{FoG.Q..score.}{Freezing of Gait Questionnaire total score.}
  \item{Initial.symptoms}{Initial Parkinson’s disease symptoms reported.}
  \item{Is.there.a.family.history.of.PD..Who.}{Family history of Parkinson’s disease and relationship.}
  \item{Do.you.feel.improvement.after.using.the.antiparkinsonian.medicine.}{Self-reported improvement after antiparkinsonian medication.}
  \item{Have.you.ever.had.any.type.of.surgery..Which.}{History of surgery and type.}
  \item{Any.rehabilitation.or.physical.activity.}{Participation in rehabilitation or regular physical activity.}
  \item{Other.disease..cardiovascular..bone..etc..}{Reported comorbid conditions (cardiovascular, bone, etc.).}
  \item{Handedness}{Dominant hand.}
  \item{ON...Hoehn...Yahr}{Hoehn and Yahr stage in the ON-medication state.}
  \item{ON...MoCA}{Montreal Cognitive Assessment (MoCA) score in the ON-medication state.}
  \item{ON...mini.BESTest}{Mini-BESTest balance score in the ON-medication state.}
  \item{ON...FES.I}{Falls Efficacy Scale–International (FES-I) score in the ON-medication state.}
  \item{ON...UPDRS.II}{UPDRS Part II (activities of daily living) total score in the ON-medication state.}
  \item{ON...UPDRS.II...walking}{UPDRS Part II walking item score in the ON-medication state.}
  \item{ON...UPDRS.III}{UPDRS Part III (motor examination) total score in the ON-medication state.}
  \item{ON...UPDRS.III...rigidity}{UPDRS Part III rigidity item score in the ON-medication state.}
  \item{ON...UPDRS.III...walking}{UPDRS Part III gait/walking item score in the ON-medication state.}
  \item{ON...PIGD.or.TD}{Motor phenotype in ON state: PIGD (postural instability/gait difficulty) or tremor-dominant (TD).}
  \item{ON...UPDRS.III.asymmetry}{Motor asymmetry index from UPDRS Part III in the ON-medication state.}
  \item{ON...Stroop.I.time..s.}{Completion time (seconds) for Stroop Test condition I in the ON-medication state.}
  \item{ON...Stroop.I.error}{Number of errors in Stroop Test condition I in the ON-medication state.}
  \item{ON...Stroop.II.time..s.}{Completion time (seconds) for Stroop Test condition II in the ON-medication state.}
  \item{ON...Stroop.II.error}{Number of errors in Stroop Test condition II in the ON-medication state.}
  \item{ON...Stroop.III.time..s.}{Completion time (seconds) for Stroop Test condition III (interference) in the ON-medication state.}
  \item{ON...Stroop.III.error}{Number of errors in Stroop Test condition III in the ON-medication state.}
  \item{ON...TMTA.time..s.}{Completion time (seconds) for Trail Making Test Part A in the ON-medication state.}
  \item{ON...TMTA.error}{Number of errors in Trail Making Test Part A in the ON-medication state.}
  \item{ON...TMTB.time.s.}{Completion time (seconds) for Trail Making Test Part B in the ON-medication state.}
  \item{ON...TMTB.error}{Number of errors in Trail Making Test Part B in the ON-medication state.}
  \item{OFF...Hoehn...Yahr}{Hoehn and Yahr stage in the OFF-medication state.}
  \item{OFF...MoCA}{Montreal Cognitive Assessment (MoCA) score in the OFF-medication state.}
  \item{OFF...mini.BESTest}{Mini-BESTest balance score in the OFF-medication state.}
  \item{OFF...FES.I}{Falls Efficacy Scale–International (FES-I) score in the OFF-medication state.}
  \item{OFF...UPDRS.II}{UPDRS Part II (activities of daily living) total score in the OFF-medication state.}
  \item{OFF...UPDRS.II...walking}{UPDRS Part II walking item score in the OFF-medication state.}
  \item{OFF...UPDRS.III}{UPDRS Part III (motor examination) total score in the OFF-medication state.}
  \item{OFF...UPDRS.III...rigidity}{UPDRS Part III rigidity item score in the OFF-medication state.}
  \item{OFF...UPDRS.III...walking}{UPDRS Part III gait/walking item score in the OFF-medication state.}
  \item{OFF...PIGD.or.TD}{Motor phenotype in OFF state: PIGD or tremor-dominant (TD).}
  \item{OFF...UPDRS.III.asymmetry}{Motor asymmetry index from UPDRS Part III in the OFF-medication state.}
  \item{OFF...Stroop.I.time..s.}{Completion time (seconds) for Stroop Test condition I in the OFF-medication state.}
  \item{OFF...Stroop.I.error}{Number of errors in Stroop Test condition I in the OFF-medication state.}
  \item{OFF...Stroop.II.time..s.}{Completion time (seconds) for Stroop Test condition II in the OFF-medication state.}
  \item{OFF...Stroop.II.error}{Number of errors in Stroop Test condition II in the OFF-medication state.}
  \item{OFF...Stroop.III.time..s.}{Completion time (seconds) for Stroop Test condition III (interference) in the OFF-medication state.}
  \item{OFF...Stroop.III.error}{Number of errors in Stroop Test condition III in the OFF-medication state.}
  \item{OFF...TMTA.time..s.}{Completion time (seconds) for Trail Making Test Part A in the OFF-medication state.}
  \item{OFF...TMTA.error}{Number of errors in Trail Making Test Part A in the OFF-medication state.}
  \item{OFF...TMTB.time.s.}{Completion time (seconds) for Trail Making Test Part B in the OFF-medication state.}
  \item{OFF...TMTB.error}{Number of errors in Trail Making Test Part B in the OFF-medication state.}
  \item{FGDI}{Freezing of Gait Diagnostic Interview score.}
}
}
\usage{
P_data_info
}
\description{
Metadata for Parkinson Subjects
}
\examples{
# Load the Data
data("P_data_info")
}
\keyword{datasets}
