% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_data.R
\name{process_metadata_file}
\alias{process_metadata_file}
\title{Process metadata file to extract variable information}
\usage{
process_metadata_file(file)
}
\arguments{
\item{file}{(String) The path to the metadata file.}
}
\value{
A list containing the scenario (e.g., \code{"single"}, \code{"single_multiple"},
\code{"single_multiple_single"}) and a tibble with variable information.
}
\description{
\code{process_metadata_file()} reads a metadata file and extracts information
about the column names, column types, decimal positions, and variable
definitions.
}
\details{
\code{process_metadata_file()} processes metadata files following specific rules
to handle encoding, remove unnecessary information, and extract variable
details. It detects the scenario based on the occurrence of double asterisks
in variable names.
}
\examples{
\donttest{

  path <- tempfile("fcadata")
  dir.create(path)

  download_data(
    year = 2025,
    month = "September",
    dest = path
  )

  process_metadata_file(file.path(path, "D_RC1.TXT"))

}
}
