% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_data.R
\name{process_data_file}
\alias{process_data_file}
\title{Process a data file using metadata and codes dictionary}
\usage{
process_data_file(file, metadata, dict = NULL)
}
\arguments{
\item{file}{(String) The path to the data file}

\item{metadata}{A list containing the scenario and variable information
obtained from the metadata file using \code{\link{process_metadata_file}}.}

\item{dict}{(Optional) A data frame containing codes dictionary information}
}
\value{
A tibble containing the processed data in a tidy format
}
\description{
\code{process_data_file()} reads a data file, applies the provided metadata and codes dictionary,
and organizes the data into a tidy format. The column names are determined based on
the metadata scenario (e.g., \code{"single"}, \code{"single_multiple"}, \code{"single_multiple_single"}).
}
\details{
\code{process_data_file()} processes the data file according to the metadata scenario.
It handles cases where variables have multiple occurrences and organizes the data
into a tidy format with appropriate column names. The function relies on the
\code{\link{read_data_file}} function for the actual data reading.
}
\examples{
\donttest{

  path <- tempfile("fcadata")
  dir.create(path)

  download_data(
    year = 2025,
    month = "September",
    dest = path
  )

  process_data_file(
    file = file.path(path, "RCB_Q202509_G20251112.TXT"),
    metadata = process_metadata_file(file.path(path, "D_RCB.TXT")),
    dict = RCB__INV_CODE
  )

}
}
