% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapset.r
\name{.mapset,GLocation-method}
\alias{.mapset,GLocation-method}
\alias{.mapset}
\alias{.mapset,missing-method}
\title{GRASS "mapset" of an object or the active session}
\usage{
\S4method{.mapset}{GLocation}(x)

\S4method{.mapset}{missing}(x)
}
\arguments{
\item{x}{A Either:
\itemize{
\item Missing: Reports mapset of currently active \strong{GRASS} "projects"/"locations".
\item A \code{GLocation} object or an object that contains the \code{GLocation} class (i.e., a \code{GSpatial} object: a \code{GRaster} or \code{GVector}): Reports the CRS of the object.
}}
}
\value{
A character string.
}
\description{
\strong{GRASS} "locations" are sets of one or more rasters and/or vectors with the same coordinate reference systems, and may or may not represent the same actual location on Earth. \strong{GRASS} "mapsets" are like subfolders of locations, and are collections of rasters and/or vectors typically related to the same general project. This function returns the mapset of an object or the current mapset. This said, \strong{fasterRaster} always uses the "PERMANENT" mapset, so there is very little reason to use this function as-is. See \code{vignette("projects_mapsets", package = "fasterRaster")}.
}
\seealso{
\strong{GRASS} \href{https://grass.osgeo.org/grass82/manuals/grass_database.html}{locations and mapsets}
}
\keyword{internal}
