% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qrsolve}
\alias{qrsolve}
\title{Solution of linear system of equations, via the QR decomposition.}
\usage{
qrsolve(A, b, type = NULL, nb = NULL)
}
\arguments{
\item{A}{an \eqn{(n\times p)} full column rank matrix.}

\item{b}{a vector of dimension \eqn{n}.}

\item{type}{either "QR" or "R". Specifies the type of decomposition to use: "QR" for the QR decomposition or "R" for the Cholesky factorization of \eqn{A^\top A}. The default is "QR".}

\item{nb}{number of blocks for the recursive block QR decomposition, default is NULL.}
}
\value{
x a vector of dimension \eqn{p} that satisfies \eqn{Ax=b}.
}
\description{
solves systems of equations \eqn{Ax=b}, for \eqn{A\in\mathbb{R}^{n\times p}} and \eqn{b\in\mathbb{R}^n}, via the QR decomposition.
}
\examples{

## generate sample data
set.seed(1234)
n <- 10
p <- 4
A <- matrix(rnorm(n * p, 1), n, p)
b <- rnorm(n)

## solve the system of linear equations using qr
x1 <- fastQR::qrsolve(A = A, b = b)
x1

## solve the system of linear equations using rb qr
x2 <- fastQR::qrsolve(A = A, b = b, nb = 2)
x2

## check
round(x1 - solve(crossprod(A)) \%*\% crossprod(A, b), 5)
round(x2 - solve(crossprod(A)) \%*\% crossprod(A, b), 5)

}
\references{
\insertRef{golub_van_loan.2013}{fastQR}

\insertRef{bjorck.2015}{fastQR}

\insertRef{bjorck.2024}{fastQR}

\insertRef{bernardi_etal.2024}{fastQR}
}
