% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qr_Q_reduced2full}
\alias{qr_Q_reduced2full}
\title{Reconstruct the full Q matrix from the reduced Q matrix.}
\usage{
qr_Q_reduced2full(Q)
}
\arguments{
\item{Q}{a \eqn{n\times p} reduced Q matrix from the QR decomposition (with \eqn{n>p}).}
}
\value{
a \eqn{n\times n} orthogonal matrix \eqn{Q}.
}
\description{
returns the full \eqn{Q\in\mathbb{R}^{n\times n}} matrix.
}
\examples{
## create data: n > p
set.seed(1234)
n <- 12
p <- 7
X <- matrix(rnorm(n * p), n, p)

## get the full QR decomposition with pivot
qr_res <- fastQR::qr_fast(X = X,
                          tol = sqrt(.Machine$double.eps),
                          pivot = TRUE)

## reconstruct the reduced Q matrix
Q1 <- qr_Q(qr = qr_res$qr, tau = qr_res$qraux,
           rank = qr_res$rank, complete = FALSE)

## complete the reduced Q matrix
Q2 <- fastQR::qr_Q_reduced2full(Q = Q1)
R  <- fastQR::qr_R(qr = qr_res$qr, rank = NULL, complete = TRUE)

X1 <- qr_X(Q = Q2, R = R, pivot = qr_res$pivot)
max(abs(X - X1))

}
\references{
\insertRef{golub_van_loan.2013}{fastQR}

\insertRef{bjorck.2015}{fastQR}

\insertRef{bjorck.2024}{fastQR}

\insertRef{bernardi_etal.2024}{fastQR}
}
