% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/G_estimate.R
\name{cov_nnls}
\alias{cov_nnls}
\title{Estimate non-negative diagonal terms on G matrix}
\usage{
cov_nnls(mum, data, L, data_cov, betaHat, GTilde, non_neg = 0, silent = TRUE)
}
\arguments{
\item{mum}{Output of massively univariate step}

\item{data}{Data frame containing all predictor and outcome variables}

\item{L}{Integer dimension of functional domain}

\item{data_cov}{Output of `G_generate`}

\item{betaHat}{Estimates of coefficients of random effects}

\item{GTilde}{Current `GTilde` estimate, created as an intermediate.}

\item{non_neg}{Integer control for non-negativity step, defaults to 0}

\item{silent}{Whether to print the step. Defaults to `TRUE`.}
}
\value{
A new GTilde matrix with enforced non-negativity
}
\description{
Helper function for `G_estimate`. Uses least squares under non-negativity
constraints, mainly relying on `nnls` capability from `lsei`.
}
\keyword{internal}
