% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-egarch-spec.R
\name{submodel-specs}
\alias{submodel-specs}
\alias{megarch_spec}
\alias{fimegarch_spec}
\alias{egarch_spec}
\alias{fiegarch_spec}
\alias{mloggarch_spec}
\alias{fimloggarch_spec}
\alias{loggarch_spec}
\alias{filoggarch_spec}
\title{EGARCH Family Submodel Specification}
\usage{
megarch_spec(
  orders = c(1, 1),
  cond_dist = c("norm", "std", "ged", "ald", "snorm", "sstd", "sged", "sald")
)

fimegarch_spec(
  orders = c(1, 1),
  cond_dist = c("norm", "std", "ged", "ald", "snorm", "sstd", "sged", "sald")
)

egarch_spec(
  orders = c(1, 1),
  cond_dist = c("norm", "std", "ged", "ald", "snorm", "sstd", "sged", "sald")
)

fiegarch_spec(
  orders = c(1, 1),
  cond_dist = c("norm", "std", "ged", "ald", "snorm", "sstd", "sged", "sald")
)

mloggarch_spec(
  orders = c(1, 1),
  cond_dist = c("norm", "std", "ged", "ald", "snorm", "sstd", "sged", "sald")
)

fimloggarch_spec(
  orders = c(1, 1),
  cond_dist = c("norm", "std", "ged", "ald", "snorm", "sstd", "sged", "sald")
)

loggarch_spec(
  orders = c(1, 1),
  cond_dist = c("norm", "std", "ged", "ald", "snorm", "sstd", "sged", "sald")
)

filoggarch_spec(
  orders = c(1, 1),
  cond_dist = c("norm", "std", "ged", "ald", "snorm", "sstd", "sged", "sald")
)
}
\arguments{
\item{orders}{a two-element numeric vector with the model
orders.}

\item{cond_dist}{a character value stating the underlying
conditional distribution to consider; available are a normal
distribution (\code{"norm"}), a \eqn{t}-distribution
(\code{"std"}), a generalized error distribution
(\code{"ged"}), an average Laplace distribution (\code{"ald"})
and the skewed versions of them
(\code{"snorm"}, \code{"sstd"}, \code{"sged"}, \code{"sald"}).}
}
\value{
Depending on the spec-fun function, either an object of class
\code{"egarch-type-spec"} or \code{"loggarch-type-spec"} is returned.
}
\description{
Wrappers of \code{fEGarch_spec()} that create
specifications of specific submodels of the broad
EGARCH family.
}
\details{
Available are shortcut specification functions for
EGARCH \code{egarch_spec()}, FIEGARCH \code{fiegarch_spec()},
MEGARCH \code{megarch_spec()}, Log-GARCH \code{loggarch_spec()},
FILog-GARCH \code{filoggarch_spec()}, MLog-GARCH \code{mloggarch_spec()},
FIMEGARCH \code{fimegarch_spec()} and
FIMLog-GARCH \code{fimloggarch_spec()}.

The following descriptions are following the descriptions in the
documentation of the more general \code{fEGarch_spec()}. Please go there
first to understand the following descriptions on the arguments of
\code{fEGarch_spec()} to obtain these wrappers.

\eqn{\textbf{EGARCH:}}

\code{model_type = "egarch"}, \code{long_memo = FALSE},
\code{powers = c(1, 1)}, \code{modulus = c(FALSE, FALSE)}

\eqn{\textbf{FIEGARCH:}}

\code{model_type = "egarch"}, \code{long_memo = TRUE},
\code{powers = c(1, 1)}, \code{modulus = c(FALSE, FALSE)}

\eqn{\textbf{MEGARCH:}}

\code{model_type = "egarch"}, \code{long_memo = FALSE},
\code{powers = c(0, 1)}, \code{modulus = c(TRUE, FALSE)}

\eqn{\textbf{Log-GARCH:}}

\code{model_type = "loggarch"}, \code{long_memo = FALSE}

\eqn{\textbf{FILog-GARCH:}}

\code{model_type = "loggarch"}, \code{long_memo = TRUE}

\eqn{\textbf{MLog-GARCH:}}

\code{model_type = "egarch"}, \code{long_memo = FALSE},
\code{powers = c(0, 0)}, \code{modulus = c(TRUE, TRUE)}

\eqn{\textbf{FIMLog-GARCH:}}

\code{model_type = "egarch"}, \code{long_memo = TRUE},
\code{powers = c(0, 0)}, \code{modulus = c(TRUE, TRUE)}

\eqn{\textbf{FIMEGARCH:}}

\code{model_type = "egarch"}, \code{long_memo = TRUE},
\code{powers = c(0, 1)}, \code{modulus = c(TRUE, FALSE)}
}
\examples{
spec <- megarch_spec(cond_dist = "std")

}
