% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exdqlmMCMC.R
\name{exdqlmMCMC}
\alias{exdqlmMCMC}
\title{exDQLM - MCMC algorithm}
\usage{
exdqlmMCMC(
  y,
  p0,
  model,
  df,
  dim.df,
  fix.gamma = FALSE,
  gam.init = NA,
  fix.sigma = FALSE,
  sig.init = NA,
  dqlm.ind = FALSE,
  Sig.mh,
  joint.sample = FALSE,
  n.burn = 2000,
  n.mcmc = 1500,
  init.from.isvb = TRUE,
  PriorSigma = NULL,
  PriorGamma = NULL,
  verbose = TRUE
)
}
\arguments{
\item{y}{A univariate time-series.}

\item{p0}{The quantile of interest, a value between 0 and 1.}

\item{model}{List of the state-space model including \code{GG}, \code{FF}, prior parameters \code{m0} and \code{C0}.}

\item{df}{Discount factors for each block.}

\item{dim.df}{Dimension of each block of discount factors.}

\item{fix.gamma}{Logical value indicating whether to fix gamma at \code{gam.init}. Default is \code{FALSE}.}

\item{gam.init}{Initial value for gamma (skewness parameter), or value at which gamma will be fixed if \code{fix.gamma=TRUE}.}

\item{fix.sigma}{Logical value indicating whether to fix sigma at \code{sig.init}. Default is \code{TRUE}.}

\item{sig.init}{Initial value for sigma (scale parameter), or value at which sigma will be fixed if \code{fix.sigma=TRUE}.}

\item{dqlm.ind}{Logical value indicating whether to fix gamma at \code{0}, reducing the exDQLM to the special case of the DQLM. Default is \code{FALSE}.}

\item{Sig.mh}{Covariance matrix used in the random walk MH step to jointly sample sigma and gamma.}

\item{joint.sample}{Logical value indicating whether or not to recompute \code{Sig.mh} based off the initial burn-in samples of gamma and sigma. Default is \code{FALSE}.}

\item{n.burn}{Number of MCMC iterations to burn. Default is \code{n.burn = 2000}.}

\item{n.mcmc}{Number of MCMC iterations to sample. Default is \code{n.mcmc = 1500}.}

\item{init.from.isvb}{Logical value indicating whether or not to initialize the MCMC using the ISVB algorithm. Default is \code{TRUE}.}

\item{PriorSigma}{List of parameters for inverse gamma prior on sigma; shape \code{a_sig} and scale \code{b_sig}. Default is an inverse gamma with mean 1 (or \code{sig.init} if provided) and variance 10.}

\item{PriorGamma}{List of parameters for truncated student-t prior on gamma; center \code{m_gam}, scale \code{s_gam} and degrees of freedom \code{df_gam}. Default is a standard student-t with 1 degree of freedom, truncated to the support of gamma.}

\item{verbose}{Logical value indicating whether progress should be displayed.}
}
\value{
A object of class "\code{exdqlmMCMC}" containing the following:
\itemize{
\item \code{y} - Time-series data used to fit the model.
\item \code{run.time} - Algorithm run time in seconds.
\item \code{model} - List of the state-space model including \code{GG}, \code{FF}, prior parameters \code{m0} and \code{C0}.
\item \code{p0} - The quantile which was estimated.
\item \code{df} - Discount factors used for each block.
\item \code{dim.df} - Dimension used for each block of discount factors.
\item \code{samp.theta} - Posterior sample of the state vector.
\item \code{samp.post.pred} - Sample of the posterior predictive distributions.
\item \code{map.standard.forecast.errors} - MAP standardized one-step-ahead forecast errors.
\item \code{samp.sigma} - Posterior sample of scale parameter sigma.
\item \code{samp.vts} - Posterior sample of latent parameters, v_t.
\item \code{theta.out} - List containing the distributions of the state vector including filtered distribution parameters (\code{fm} and \code{fC}) and smoothed distribution parameters (\code{sm} and \code{sC}).
\item \code{n.burn} Number of MCMC iterations that were burned.
\item \code{n.mcmc} Number of MCMC iterations that were sampled.
}
If \code{dqlm.ind=FALSE}, the object also contains the following:
\itemize{
\item \code{samp.gamma} - Posterior sample of skewness parameter gamma.
\item \code{samp.sts} - Posterior sample of latent parameters, s_t.
\item \code{init.log.sigma} - Burned samples of log sigma from the random walk MH joint sampling of sigma and gamma.
\item \code{init.logit.gamma} - Burned samples of logit gamma from the random walk MH joint sampling of sigma and gamma.
\item \code{accept.rate} - Acceptance rate of the MH step.
\item \code{Sig.mh} - Covariance matrix used in MH step to jointly sample sigma and gamma.
}
}
\description{
The function applies a Markov chain Monte Carlo (MCMC) algorithm to sample the posterior of an exDQLM.
}
\examples{
\donttest{
y = scIVTmag[1:100]
trend.comp = polytrendMod(1,mean(y),10)
seas.comp = seasMod(365,c(1,2,4),C0=10*diag(6))
model = trend.comp + seas.comp
M2 = exdqlmMCMC(y,p0=0.85,model,df=c(1,1),dim.df = c(1,6),
                gam.init=-3.5,sig.init=15,
                n.burn=100,n.mcmc=150)
}

}
