% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exdqlmDiagnostics.R
\name{exdqlmDiagnostics}
\alias{exdqlmDiagnostics}
\title{exDQLM Diagnostics}
\usage{
exdqlmDiagnostics(
  m1,
  m2 = NULL,
  plot = TRUE,
  cols = c("red", "blue"),
  ref = NULL
)
}
\arguments{
\item{m1}{An object of class "\code{exdqlmMCMC}" or "\code{exdqlmISVB}".}

\item{m2}{An optional additional object of class "\code{exdqlmMCMC}" or "\code{exdqlmISVB}" to compare with \code{m1}.}

\item{plot}{If \code{TRUE}, the following will be plotted for \code{m1} and \code{m2} (if provided): a qq-plot and ACF plot of the MAP one-step-ahead distribution sequence, and a time series plot of the standardized forecast errors.}

\item{cols}{Color(s) used to plot diagnostics.}

\item{ref}{Reference sample of size \code{length(y)} from a standard normal distribution used to compute the KL divergence.}
}
\value{
A object of class "\code{exdqlmDiagnostics}" containing the following:
\itemize{
\item \code{m1.uts} - The one-step-ahead distribution sequence of \code{m1}.
\item \code{m1.KL} - The KL divergence of \code{m1.uts} and a standard normal.
\item \code{m1.pplc} - The posterior predictive loss criterion of \code{m1} based off the check loss function.
\item \code{m1.qq} - The ordered pairs of the qq-plot comparing \code{m1.uts} with a standard normal distribution.
\item \code{m1.acf} - The autocorrelations of \code{m1.uts} by lag.
\item \code{m1.rt} - Run-time of the original model \code{m1} in seconds.
\item \code{m1.msfe} - MAP standardized one-step-ahead forecast errors from the original model \code{m1}.
\item \code{y} - The original time-series used to fit \code{m1}.
}
If \code{m2} is provided, analogous results for \code{m2} are also included in the list.
}
\description{
The function computes the following for the model(s) provided: the posterior predictive loss criterion based off the check loss, the one-step-ahead distribution sequence and its KL divergence from normality. The function also plots the following: the qq-plot and ACF plot corresponding to the one-step-ahead distribution sequence, and a time series plot of the MAP standard forecast errors.
}
\examples{
\donttest{
y = scIVTmag[1:100]
model = polytrendMod(1,mean(y),10)
M0 = exdqlmISVB(y,p0=0.85,model,df=c(0.95),dim.df = c(1),
                  gam.init=-3.5,sig.init=15)
M0.diags = exdqlmDiagnostics(M0,plot=FALSE)
}

}
