% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{BrestSurgeMaxima}
\alias{BrestSurgeMaxima}
\title{Annual maxima sea surge heights at Brest, France}
\format{
\code{BrestSurgeMaxima} is a data frame with 162 rows (years 1846 to
2007) and the 4 variables:
\itemize{
\item \code{maxima}: annual maximum surge height at high tide in cm.
\item \code{notNA} : the number of days of the year for which raw data were available.
\item \code{n} : the number of days in the year (365 or 366).
\item \code{block} : a block number of 1 for year 1846 through to 162 for year 2007.
}

The row names of \code{BrestSurgeMaxima} are the years \code{1946:2007}.
}
\source{
The dataset \code{Brest} in the \code{Renext} R package, specifically
\code{Brest$OTdata} and \code{Brest$OTmissing}. Originally, the source was
\url{https://data.shom.fr/}.
}
\usage{
BrestSurgeMaxima
}
\description{
Annual maxima of sea surge heights near high tide at Brest tide gauge
station (France) for the years 1846-2007 inclusive.
}
\note{
The raw data are missing for approximately \eqn{9\%} of the days.
The data were declustered by the original providers in order to provide a
series of independent surge heights at high tide. Specifically, these
surge heights are separated by at least two days. A correction was applied
to account for trend in the sea-level over the observation period.
Although the declustering of the data means that the effective block size is
smaller than \code{n}, it may be reasonable to suppose that the proportion
\code{notNA/n} of non-missing values provides a useful measure of the extent to
which the size of an annual maximum is likely to be affected by missingness.
}
\examples{
head(BrestSurgeMaxima)

# Time series plot of annual maxima surges
plot(rownames(BrestSurgeMaxima), BrestSurgeMaxima$maxima,
     ylab = "surge (cm)", xlab = "year", pch = 16)

# Time series plot of proportion of non-missing days
plot(rownames(BrestSurgeMaxima), BrestSurgeMaxima$notNA / BrestSurgeMaxima$n,
     ylab = "proportion of non-missing days", xlab = "year", pch = 16)

# Plot surges against the proportion of non-missing days
plot(BrestSurgeMaxima$notNA / BrestSurgeMaxima$n, BrestSurgeMaxima$maxima,
     ylab = "surge (cm)", xlab = "proportion of non-missing days", pch = 16)
}
\references{
Deville Y. and Bardet L. (2023). Renext: Renewal Method for
Extreme Values Extrapolation. R package version 3.1-4.
\doi{https://doi.org/10.32614/CRAN.package.Renext}
}
\seealso{
\itemize{
\item \code{\link{BrestSurgeMissing}}: numbers of missing values in each month.
\item \code{\link{BrestSurgeDays}}: Number of days per month in 1846-2007.
}
}
\keyword{datasets}
