% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_safety_xml.R
\name{simple_safety_xml}
\alias{simple_safety_xml}
\title{creates a simple xml file from the input of a safety_summary object}
\usage{
simple_safety_xml(
  x,
  file,
  schema = system.file("extdata", "simple.xsd", package = "eudract")
)
}
\arguments{
\item{x}{an object of class \code{safety_summary}, as created by \code{\link{safety_summary}}.}

\item{file}{a character string name the file to be created}

\item{schema}{a character string giving the file path to the schema for the output
xml file. Defaults to the schema provided in this package.}
}
\value{
no output is returned, but a file is created as a side-effect.
}
\description{
creates a simple xml file from the input of a safety_summary object
}
\examples{
safety_statistics <- safety_summary(safety,
                                    exposed=c("Experimental"=60,"Control"=67))
simple <- tempfile(fileext = ".xml")
eudract <- tempfile(fileext = ".xml")
ct <- tempfile(fileext = ".xml")
simple_safety_xml(safety_statistics, simple)
eudract_convert(input=simple,
                output=eudract)
clintrials_gov_convert(input=simple,
                       original=system.file("extdata", "1234.xml", package ="eudract"),
                output=ct)
\dontrun{
  # This needs a real user account to work
  clintrials_gov_upload(
    input=simple,
    orgname="CTU",
    username="Student",
    password="Guinness",
    studyid="1234"
    )

}
}
\seealso{
\code{\link{eudract_convert}} \code{\link{safety_summary}}
}
