% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boin_comb_selector.R, R/interface.R
\name{prob_tox_quantile.boin_comb_selector}
\alias{prob_tox_quantile.boin_comb_selector}
\alias{prob_tox_quantile}
\title{Quantile of the toxicity rate at each dose.}
\usage{
\method{prob_tox_quantile}{boin_comb_selector}(x, p, iso = TRUE, ...)

prob_tox_quantile(x, p, ...)
}
\arguments{
\item{x}{Object of class \code{\link{selector}}}

\item{p}{quantile probability, decimal value between 0 and 1}

\item{iso}{TRUE to use isotonic regression on the posterior quantiles; FALSE
to return just the posterior quantiles, which may not be monotonically
increasing by dose.}

\item{...}{arguments passed to other methods}
}
\value{
a numerical vector
}
\description{
Get the estimated quantile of the toxicity rate at each dose under
investigation. This is a set of modelled statistics. The underlying models
estimate toxicity probabilities in different ways. If no model-based
estimate of the median is available, this function will return a vector of
NAs.
}
\examples{
# CRM example
skeleton <- c(0.05, 0.1, 0.25, 0.4, 0.6)
target <- 0.25
outcomes <- '1NNN 2NTN'
fit <- get_dfcrm(skeleton = skeleton, target = target) \%>\% fit(outcomes)
fit \%>\% prob_tox_quantile(p = 0.9)
}
