% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epe4md_calcula.R
\name{epe4md_sumariza_resultados}
\alias{epe4md_sumariza_resultados}
\title{Resume os resultados de capacidade instalada}
\usage{
epe4md_sumariza_resultados(resultados_mensais)
}
\arguments{
\item{resultados_mensais}{data.frame. Saída da função
\code{epe4md::epe4md_calcula}}
}
\value{
data.frame com projeção de capacidade instalada nacional, em GW e
geração de energia, em GWh e MWméd.
}
\description{
Resume os resultados de capacidade instalada
}
\examples{

resultados_mensais <- structure(
  list(data = structure(c(18628, 18628, 18628),
       class = "Date"),
       ano = c(2021, 2021, 2021),
       mes = c(1, 1, 1),
       nome_4md = c("RORAIMA", "SULGIPE", "UHENPAL"),
       subsistema = c("MAN", "NE", "S"),
       uf = c("RR", "SE", "RS"),
       segmento = c("comercial_at", "comercial_at", "comercial_bt"),
       fonte_resumo = c("Fotovoltaica", "Fotovoltaica", "Fotovoltaica"),
       energia_mwh = c(536.436102870736, 83.2181016179793, 128.993567632682),
       energia_autoc_mwh = c(429.148882296589, 66.5744812943834, 64.4967838163411),
       energia_inj_mwh = c(107.287220574147, 16.6436203235959, 64.4967838163411),
       energia_mwmed = c(Jan = 0.721016267299377, Jan = 0.11185228712094, Jan = 0.173378451119196),
       pot_mes_mw = c(0, 0, 0.05441),
       adotantes_mes = c(0, 0, 5),
       p = c(0.000122345127598721, 0.000242743031345856, 0.00368794049368357),
       q = c(1, 1, 0.550183036478482)),
  row.names = c(NA, -3L),
  class = c("tbl_df", "tbl", "data.frame")
)

resultado <- epe4md_sumariza_resultados(resultados_mensais)
}
