% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csem_binomial.R
\name{csem_binomial}
\alias{csem_binomial}
\title{CSEM and CSSEM with Binomial Model}
\usage{
csem_binomial(ni, ct = NULL)
}
\arguments{
\item{ni}{A single numeric value indicating the number of items.}

\item{ct}{An optional data frame or matrix containing a conversion table with
two columns: the first column as raw scores (0 to \code{ni}) and the second
column as scale scores.}
}
\value{
A list with:
\describe{
\item{x}{A vector of raw scores from 0 to \code{ni}.}
\item{csem}{A vector of CSEM values (on the raw-score metric) for each
raw score.}
\item{cssem}{If \code{ct} is provided, a vector of CSSEM values for the
scale scores corresponding to each raw score.}
}
}
\description{
Compute the conditional standard error of measurement (CSEM) and conditional
standard error of scaled scores (CSSEM) under the binomial model.
}
\details{
Under the binomial model, for a test with \eqn{n_i} items and a true-score
proportion \eqn{\pi}, the distribution of raw scores is assumed to be
\eqn{\mathrm{Binomial}(n_i, \pi)}. This function treats each possible raw
score \eqn{k = 0, 1, \ldots, n_i} as the true-score value (i.e.,
\eqn{\pi_k = k / n_i}) and computes:
\itemize{
\item the CSEM of the raw scores; and
\item if \code{ct} is provided, the CSSEM of the scale scores defined in
the conversion table.
}
}
\examples{
csem_binomial(40)
csem_binomial(40, ct.u)

}
