% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-cache.R
\name{set_cache_dir}
\alias{set_cache_dir}
\title{Set the cache directory for educabR}
\usage{
set_cache_dir(path = NULL, persistent = FALSE)
}
\arguments{
\item{path}{A character string with the path to the cache directory.
If \code{NULL}, uses a temporary directory (default).}

\item{persistent}{Logical. If \code{TRUE}, the cache directory setting is
saved to the user's R profile for future sessions.}
}
\value{
Invisibly returns the cache directory path.
}
\description{
Sets the directory where downloaded files will be cached. This avoids
repeated downloads of the same data.
}
\examples{
\dontrun{
# set a custom cache directory (use tempdir() in examples)
set_cache_dir(file.path(tempdir(), "educabR_cache"))
}
}
