% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{top_stations}
\alias{top_stations}
\title{Top Weather Stations for Each Organism}
\format{
A tibble with 12 rows and 2 variables:
\describe{
  \item{organism}{Name of the organism (e.g., "glowworms", "orchids")}
  \item{ws_id}{Weather station ID (e.g., "948720-99999")}
}
}
\usage{
top_stations
}
\description{
A lookup table identifying the top 3 most frequently linked weather stations
for each focal organism in the ecotourism package. These stations were selected
based on the number of linked observations across a 10-year period (2014–2024).
}
\details{
This table was created by counting the frequency of `ws_id` assignments within each organism dataset
and selecting the top 3 stations per organism. These top stations are used for downloading daily
weather data via the \pkg{GSODR} package.
}
\examples{
data(top_stations)
head(top_stations)
}
\seealso{
\code{\link{weather}}, \code{\link{weather_stations}}
}
\keyword{datasets}
