% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{manta_rays}
\alias{manta_rays}
\title{Manta Ray Occurrence Data (2014–2024)}
\format{
A tibble with 1,088 rows and 14 variables:
\describe{
  \item{obs_lat}{Latitude of the observation (decimal degrees)}
  \item{obs_lon}{Longitude of the observation (decimal degrees)}
  \item{date}{Date of the observation (YYYY-MM-DD)}
  \item{time}{Time of the observation (HH:MM:SS)}
  \item{year}{Year of the observation}
  \item{month}{Month (1–12)}
  \item{day}{Day of the month}
  \item{hour}{Hour extracted from the time (0–23)}
  \item{weekday}{Day of the week (as ordered factor)}
  \item{dayofyear}{Day of the year (1–366)}
  \item{sci_name}{Scientific name — all observations are \emph{Mobula alfredi}}
  \item{record_type}{Type of observation (e.g., MACHINE_OBSERVATION)}
  \item{obs_state}{Australian state where the observation occurred (may be missing)}
  \item{ws_id}{Nearest weather station ID (e.g., "947800-99999")}
}
}
\source{
Atlas of Living Australia via \pkg{galah}
}
\usage{
manta_rays
}
\description{
This dataset contains occurrence records for the reef manta ray (*Mobula alfredi*)
observed in Australian waters from 2014 to 2024. The data includes spatial and temporal
metadata, species identifiers, and linked weather station IDs.
}
\details{
Records were accessed using the \pkg{galah} package and filtered specifically
for *Mobula alfredi*. Data has been cleaned and enriched with spatial proximity
to weather stations for climate-related analysis.
}
\examples{
data(manta_rays)
head(manta_rays)
}
\seealso{
\code{\link{gouldian_finch}}, \code{\link{weather}}
}
\keyword{datasets}
