% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugins.R
\name{e_contour}
\alias{e_contour}
\title{Contour chart}
\usage{
e_contour(
  e,
  serie,
  name = "contour",
  legend = TRUE,
  thresholds = 8,
  bandwidth = 20,
  lineStyle = list(opacity = 0.3, color = "black", width = 1),
  contourOpacity = 0.8,
  contourColors = list("#5470c6", "#91cc75", "#fac858", "#ee6666"),
  ...
)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{serie}{Column name of serie to plot.}

\item{name}{name of the serie.}

\item{legend}{Whether to add serie to legend.}

\item{thresholds}{contour density}

\item{bandwidth}{the size of the contours}

\item{lineStyle}{list of properties of the line}

\item{contourOpacity}{opacity of the countours}

\item{contourColors}{colors used for the contours}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Draw a contour plot. x and y must each be numbers.
}
\examples{

mtcars |>
 e_charts(mpg) |>
 e_contour(serie = mpg)
}
\seealso{
\href{https://github.com/apache/echarts-custom-series/tree/main/custom-series/contour}{official documentation}
}
