% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter-diagnostics.R
\name{filter_keep}
\alias{filter_keep}
\alias{filter_keep.data.table}
\title{Filter Data with Diagnostic Statistics}
\usage{
filter_keep(x, ...)

\method{filter_keep}{data.table}(
  x,
  expr,
  stat = NULL,
  na_as = FALSE,
  quiet = FALSE,
  warn_threshold = NULL,
  ...
)
}
\arguments{
\item{x}{A data.table or other object.}

\item{...}{Arguments passed to methods.}

\item{expr}{A filtering expression written in terms of columns of x.
Rows where expr is TRUE are KEPT; others are dropped.}

\item{stat}{An unquoted column or expression to total, e.g., sales,
price*qty, etc. Reports the amount dropped and its share of total.}

\item{na_as}{Logical. Treat NA results of expr as this value
(default FALSE: drop rows where expr is NA).}

\item{quiet}{Logical. If TRUE, suppress printing diagnostics.}

\item{warn_threshold}{Numeric between 0 and 1. If set and the proportion of
dropped rows exceeds this threshold, a warning is issued.}
}
\value{
The filtered data.table.
}
\description{
Filters a data.table while reporting statistics about dropped rows and
optionally the sum of a statistic column that was dropped.
}
\section{Methods (by class)}{
\itemize{
\item \code{filter_keep(data.table)}: Method for data.table objects

}}
\examples{
library(data.table)
DT <- data.table(
  id = 1:6,
  keep = c(TRUE, FALSE, TRUE, NA, TRUE, FALSE),
  sales = c(100, 50, 200, 25, NA, 75)
)

# Keep rows where keep == TRUE; report dropped statistics
DT2 <- filter_keep(DT, keep == TRUE)

# Also report dropped sales value
DT3 <- filter_keep(DT, keep == TRUE, stat = sales)

}
