% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_dtGAP.R
\name{compare_dtGAP}
\alias{compare_dtGAP}
\title{Compare Multiple Decision Tree Models Side-by-Side}
\usage{
compare_dtGAP(
  models = c("rpart", "party"),
  data_train = NULL,
  data_test = NULL,
  data_all = NULL,
  target_lab = NULL,
  show = c("all", "train", "test"),
  test_size = 0.3,
  task = c("classification", "regression"),
  total_w = 594,
  total_h = 210,
  ...
)
}
\arguments{
\item{models}{Character vector of length >= 2. Models to compare.
Each must be one of \code{"rpart"}, \code{"party"}, \code{"C50"}, or
\code{"caret"}.}

\item{data_train}{Data frame. Training data.}

\item{data_test}{Data frame. Test data.}

\item{data_all}{Data frame. Full dataset (alternative to separate train/test).}

\item{target_lab}{Character. Name of the target column.}

\item{show}{Character. Which subset to show: \code{"all"}, \code{"train"},
or \code{"test"}.}

\item{test_size}{Numeric. Proportion for test split (default 0.3).}

\item{task}{Character. \code{"classification"} or \code{"regression"}.}

\item{total_w}{Numeric. Total page width in mm (default 594, 2x A4 width).}

\item{total_h}{Numeric. Total page height in mm (default 210).}

\item{...}{Additional visual parameters passed to each dtGAP panel
(e.g. \code{trans_type}, \code{col_proximity}, \code{print_eval}).}
}
\value{
Draws the side-by-side comparison to the current graphics device.
Called for its side effect; returns invisibly.
}
\description{
Runs the dtGAP pipeline for each specified model and composes the results
side-by-side on a single wide page. Shared data preparation is performed
once; each model gets its own tree + heatmap panel.
}
\examples{
\donttest{
compare_dtGAP(
  models = c("rpart", "party"),
  data_all = Psychosis_Disorder,
  target_lab = "UNIQID",
  show = "all",
  trans_type = "none",
  print_eval = FALSE
)
}
}
