% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.if_else.R
\name{ds.if_else}
\alias{ds.if_else}
\title{Vectorised if-else}
\usage{
ds.if_else(
  condition = NULL,
  true = NULL,
  false = NULL,
  missing = NULL,
  ptype = NULL,
  size = NULL,
  newobj = NULL,
  datasources = NULL
)
}
\arguments{
\item{condition}{A list specifying a logical vector in tidyverse syntax, ie data and column names unquoted.}

\item{true}{Vector to use for TRUE value of condition.}

\item{false}{Vector to use for FALSE value of condition.}

\item{missing}{If not NULL, will be used as the value for NA values of condition. Follows the same size and type rules as true and false.}

\item{ptype}{An optional prototype declaring the desired output type. If supplied, this overrides the common type of true, false, and missing.}

\item{size}{An optional size declaring the desired output size. If supplied, this overrides the size of condition.}

\item{newobj}{Character specifying name for new server-side data frame.}

\item{datasources}{datashield connections object.}
}
\value{
No return value, called for its side effects. A vector with the same size as
\code{condition} and the same type as the common type of \code{true}, \code{false}, and
\code{missing} is created on the server.
}
\description{
DataSHIELD implementation of \code{dplyr::if_else}.
}
\examples{
\dontrun{
## First log in to a DataSHIELD session with mtcars dataset loaded.


## Refer to the package vignette for more examples.
}
}
