% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TimeTreesFunctions.R
\name{getTimeTreesIterate}
\alias{getTimeTreesIterate}
\title{Iteratively resume getTimeTrees until convergence, as defined by 
all parameters (except those in \code{ignore} vector) having ESS 
greater than or equal to the specified ess_cutoff}
\usage{
getTimeTreesIterate(
  clones,
  iterations = 10,
  ess_cutoff = 200,
  ignore = c("traitfrequencies"),
  quiet = 0,
  ...
)
}
\arguments{
\item{clones}{a tibble of \code{airrClone} objects, the output of
\link{formatClones}}

\item{iterations}{Maximum number of times to resume MCMC chain}

\item{ess_cutoff}{Minimum number of ESS for all parameters}

\item{ignore}{Vector of parameters to ignore for ESS calculation}

\item{quiet}{quiet notifications if > 0}

\item{...}{Additional arguments for getTimeTrees}
}
\value{
A tibble of \code{tidytree} and \code{airrClone} objects.
}
\description{
\code{getTimeTreesIterate} Iteratively resume getTimeTrees til convergence.
}
\details{
For examples and vignettes, see https://dowser.readthedocs.io
}
