% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.hdlmm.R
\name{sim.hdlmm}
\alias{sim.hdlmm}
\title{Creates simulated data for HDLM & HDLMM}
\usage{
sim.hdlmm(
  sim = "A",
  n = 1000,
  error = 1,
  effect.size = 1,
  exposure.data = NULL
)
}
\arguments{
\item{sim}{character (A - E) specifying simulation scenario}

\item{n}{sample size}

\item{error}{positive scalar specifying error variance for Gaussian response}

\item{effect.size}{the effect size of the window of susceptibility}

\item{exposure.data}{exposure data. A matrix of exposure data for simulation A, B, C and a named list of exposure data for simulation D, E}
}
\value{
Simulated data and true parameters
}
\description{
Method for creating simulated data for HDLM & HDLMM
}
\details{
sim.hdlmm

Simulation scenarios:
\itemize{
\item Scenario A: Two subgroups with early/late windows determined by continuous and binary modifiers
\item Scenario B: Two subgroups with scaled effect determined by a continuous modifier
\item Scenario C: No heterogeneity i.e., same effect on all individuals
\item Scenario D: Three subgroups with three corresponding exposures. Subgroups are determined by continuous and binary modifiers
\item Scenario E: Two subgroups with two exposures. First group is associated with the scaled main effect and lagged interaction
while the second group is only associated with the scaled main effect, no interaction.
}
}
\examples{
sim.hdlmm(sim = "A", n = 1000)

}
