% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.r
\name{truncatedLaplace}
\alias{truncatedLaplace}
\title{Compute truncated Laplace distribution weights}
\usage{
truncatedLaplace(x, laplaceScale)
}
\arguments{
\item{x}{A vector of integers representing centered SNP positions.}

\item{laplaceScale}{Scale parameter of the Laplace distribution.}
}
\value{
A numeric vector of weights.
}
\description{
Evaluates a Laplace distribution truncated to 95\% of its area, with weights scaled to \code{10/19}.
}
\details{
\code{x} must be within \code{+- laplaceScale * log(20)}.
}
\keyword{internal}
