% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.r
\name{resolveCompartments}
\alias{resolveCompartments}
\title{Resolve compartments for diem input files}
\usage{
resolveCompartments(files, toBeCompartmentalized, compartmentSizes = NULL)
}
\arguments{
\item{files}{Paths to diem input files.}

\item{toBeCompartmentalized}{Either \code{"all"} or a logical vector specifying sites to compartmentalize.}

\item{compartmentSizes}{Optional vector specifying the number of sites per file.}
}
\value{
A list of logical vectors corresponding to each file.
}
\description{
Generates a list of logical vectors indicating which sites should be compartmentalized.
If \code{toBeCompartmentalized} is \code{"all"}, all sites are marked as \code{TRUE}. Otherwise, a logical vector
must be provided with a length matching the total number of sites.
}
\keyword{internal}
