% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_regression.R
\name{linreg}
\alias{linreg}
\title{Linear Regression Summary Table}
\arguments{
\item{data}{A data frame or tibble containing the variables.}

\item{outcome}{The name of the outcome variable (numeric) as a string.}

\item{predictors}{A character vector of predictor variable names.}
}
\value{
A \code{flextable} object summarizing univariate and multivariate linear regression results.
}
\description{
This function performs univariate and multivariate linear regression analyses
for the specified predictors and outcome variable, returning a summary table
with characteristics, regression coefficients (\eqn{\beta}) with 95\\% CI, and p-values.
Numeric variables are summarized as mean (SD); categorical variables as n (\\%).
Multivariate model R^2 and adjusted R^2 are included in the table footer.
}
\examples{
# Example using built-in iris dataset
linreg(iris, outcome = "Sepal.Length",
       predictors = c("Sepal.Width", "Petal.Length", "Species"))
}
