% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_eml_list.R
\name{as_eml_list}
\alias{as_eml_list}
\alias{as_eml_list.tbl_lp}
\alias{as_eml_list.tbl_df}
\alias{as_eml_list.list}
\alias{as_eml_list.xml_document}
\title{Convert metadata to a \code{list}}
\usage{
as_eml_list(x, ...)

\method{as_eml_list}{tbl_lp}(x, ...)

\method{as_eml_list}{tbl_df}(x, ...)

\method{as_eml_list}{list}(x, ...)

\method{as_eml_list}{xml_document}(x, ...)
}
\arguments{
\item{x}{Object to be converted}

\item{...}{Other arguments, currently ignored}
}
\value{
A list, where both the nested structure of the XML/md and the
attributes of XML nodes, are preserved.
}
\description{
Takes an object of class \code{xml_document} or \code{tibble}, and
converts it to a \code{list}. When converting from an \code{xml_document}, this is
simply a wrapper for \code{xml2::as_list()}
}
\examples{
source_file <- system.file("extdata", 
                           "bionet_metadata.Rmd",
                           package = "delma")
df <- read_md(source_file)
as_eml_list(df) |> str()
}
